<?php
/**
 * Exchange Resets
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

echo '<h2>Exchange Resets Logs</h2>';

try {
	$ExchangeResets = new \Plugin\ExchangeResets\ExchangeResets();
	$logs = $ExchangeResets->getExchangedResetsList();
	if(!is_array($logs)) throw new Exception('There are no exchange logs.');
	
	echo '<table class="table table-hover table-striped">';
		echo '<thead>';
			echo '<th>Character</th>';
			echo '<th>Exchanged Resets</th>';
		echo '</thead>';
		echo '<tbody>';
		foreach($logs as $row) {
			echo '<tr>';
				echo '<td>'.$row['character'].'</td>';
				echo '<td>'.number_format($row['exchanged_resets']).'</td>';
			echo '</tr>';
		}
		echo '</tbody>';
	echo '</table>';

} catch(Exception $ex) {
	message('warning', $ex->getMessage());
}